/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.gui.JListHelper;
import weka.gui.PropertySheetPanel;
import weka.gui.beans.BeanCustomizer;
import weka.gui.beans.CustomizerCloseRequester;
import weka.gui.beans.EnvironmentField;
import weka.gui.beans.SubstringLabeler;

public class SubstringLabelerCustomizer
extends JPanel
implements EnvironmentHandler,
BeanCustomizer,
CustomizerCloseRequester {
    private static final long serialVersionUID = 7636584212353183751L;
    protected Environment m_env = Environment.getSystemWide();
    protected BeanCustomizer.ModifyListener m_modifyL = null;
    protected SubstringLabeler m_labeler;
    protected EnvironmentField m_matchAttNameField;
    protected EnvironmentField m_attListField;
    protected EnvironmentField m_matchField;
    protected EnvironmentField m_labelField;
    protected JCheckBox m_regexCheck = new JCheckBox();
    protected JCheckBox m_ignoreCaseCheck = new JCheckBox();
    protected JCheckBox m_nominalBinaryCheck = new JCheckBox();
    protected JCheckBox m_consumeNonMatchingCheck = new JCheckBox();
    protected JList m_list = new JList();
    protected DefaultListModel m_listModel;
    protected JButton m_newBut = new JButton("New");
    protected JButton m_deleteBut = new JButton("Delete");
    protected JButton m_upBut = new JButton("Move up");
    protected JButton m_downBut = new JButton("Move down");
    protected Window m_parent;
    protected PropertySheetPanel m_tempEditor = new PropertySheetPanel();

    public SubstringLabelerCustomizer() {
        this.setLayout(new BorderLayout());
    }

    private void setup() {
        JPanel aboutAndControlHolder = new JPanel();
        aboutAndControlHolder.setLayout(new BorderLayout());
        JPanel controlHolder = new JPanel();
        controlHolder.setLayout(new BorderLayout());
        JPanel fieldHolder = new JPanel();
        JPanel attListP = new JPanel();
        attListP.setLayout(new BorderLayout());
        attListP.setBorder(BorderFactory.createTitledBorder("Apply to attributes"));
        this.m_attListField = new EnvironmentField(this.m_env);
        attListP.add((Component)this.m_attListField, "Center");
        attListP.setToolTipText("<html>Accepts a range of indexes (e.g. '1,2,6-10')<br> or a comma-separated list of named attributes</html>");
        JPanel matchP = new JPanel();
        matchP.setLayout(new BorderLayout());
        matchP.setBorder(BorderFactory.createTitledBorder("Match"));
        this.m_matchField = new EnvironmentField(this.m_env);
        matchP.add((Component)this.m_matchField, "Center");
        JPanel labelP = new JPanel();
        labelP.setLayout(new BorderLayout());
        labelP.setBorder(BorderFactory.createTitledBorder("Label"));
        this.m_labelField = new EnvironmentField(this.m_env);
        labelP.add((Component)this.m_labelField, "Center");
        fieldHolder.add(attListP);
        fieldHolder.add(matchP);
        fieldHolder.add(labelP);
        controlHolder.add((Component)fieldHolder, "North");
        JPanel checkHolder = new JPanel();
        checkHolder.setLayout(new GridLayout(0, 2));
        JLabel attNameLab = new JLabel("Name of label attribute", 4);
        checkHolder.add(attNameLab);
        this.m_matchAttNameField = new EnvironmentField(this.m_env);
        this.m_matchAttNameField.setText(this.m_labeler.getMatchAttributeName());
        checkHolder.add(this.m_matchAttNameField);
        JLabel regexLab = new JLabel("Match using a regular expression", 4);
        regexLab.setToolTipText("Use a regular expression rather than literal match");
        checkHolder.add(regexLab);
        checkHolder.add(this.m_regexCheck);
        JLabel caseLab = new JLabel("Ignore case when matching", 4);
        checkHolder.add(caseLab);
        checkHolder.add(this.m_ignoreCaseCheck);
        JLabel nominalBinaryLab = new JLabel("Make binary label attribute nominal", 4);
        nominalBinaryLab.setToolTipText("<html>If the label attribute is binary (i.e. no <br>explicit labels have been declared) then<br>this makes the resulting attribute nominal<br>rather than numeric.</html>");
        checkHolder.add(nominalBinaryLab);
        checkHolder.add(this.m_nominalBinaryCheck);
        this.m_nominalBinaryCheck.setSelected(this.m_labeler.getNominalBinary());
        JLabel consumeNonMatchLab = new JLabel("Consume non-matching instances", 4);
        consumeNonMatchLab.setToolTipText("<html>When explicit labels have been defined, consume <br>(rather than output with missing value) instances</html>");
        checkHolder.add(consumeNonMatchLab);
        checkHolder.add(this.m_consumeNonMatchingCheck);
        this.m_consumeNonMatchingCheck.setSelected(this.m_labeler.getConsumeNonMatching());
        controlHolder.add((Component)checkHolder, "South");
        aboutAndControlHolder.add((Component)controlHolder, "South");
        JPanel aboutP = this.m_tempEditor.getAboutPanel();
        aboutAndControlHolder.add((Component)aboutP, "North");
        this.add((Component)aboutAndControlHolder, "North");
        this.m_list.setVisibleRowCount(5);
        this.m_deleteBut.setEnabled(false);
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BorderLayout());
        JPanel butHolder = new JPanel();
        butHolder.setLayout(new GridLayout(1, 0));
        butHolder.add(this.m_newBut);
        butHolder.add(this.m_deleteBut);
        butHolder.add(this.m_upBut);
        butHolder.add(this.m_downBut);
        this.m_upBut.setEnabled(false);
        this.m_downBut.setEnabled(false);
        listPanel.add((Component)butHolder, "North");
        JScrollPane js = new JScrollPane(this.m_list);
        js.setBorder(BorderFactory.createTitledBorder("Match-list list (rows applied in order)"));
        listPanel.add((Component)js, "Center");
        this.add((Component)listPanel, "Center");
        this.addButtons();
        this.m_attListField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Object m = SubstringLabelerCustomizer.this.m_list.getSelectedValue();
                if (m != null) {
                    ((SubstringLabeler.Match)m).setAttsToApplyTo(SubstringLabelerCustomizer.this.m_attListField.getText());
                    SubstringLabelerCustomizer.this.m_list.repaint();
                }
            }
        });
        this.m_matchField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Object m = SubstringLabelerCustomizer.this.m_list.getSelectedValue();
                if (m != null) {
                    ((SubstringLabeler.Match)m).setMatch(SubstringLabelerCustomizer.this.m_matchField.getText());
                    SubstringLabelerCustomizer.this.m_list.repaint();
                }
            }
        });
        this.m_labelField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Object m = SubstringLabelerCustomizer.this.m_list.getSelectedValue();
                if (m != null) {
                    ((SubstringLabeler.Match)m).setLabel(SubstringLabelerCustomizer.this.m_labelField.getText());
                    SubstringLabelerCustomizer.this.m_list.repaint();
                }
            }
        });
        this.m_list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    Object entry;
                    if (!SubstringLabelerCustomizer.this.m_deleteBut.isEnabled()) {
                        SubstringLabelerCustomizer.this.m_deleteBut.setEnabled(true);
                    }
                    if ((entry = SubstringLabelerCustomizer.this.m_list.getSelectedValue()) != null) {
                        SubstringLabeler.Match m = (SubstringLabeler.Match)entry;
                        SubstringLabelerCustomizer.this.m_attListField.setText(m.getAttsToApplyTo());
                        SubstringLabelerCustomizer.this.m_matchField.setText(m.getMatch());
                        SubstringLabelerCustomizer.this.m_labelField.setText(m.getLabel());
                        SubstringLabelerCustomizer.this.m_regexCheck.setSelected(m.getRegex());
                        SubstringLabelerCustomizer.this.m_ignoreCaseCheck.setSelected(m.getIgnoreCase());
                    }
                }
            }
        });
        this.m_newBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubstringLabeler.Match m = new SubstringLabeler.Match();
                String atts = SubstringLabelerCustomizer.this.m_attListField.getText() != null ? SubstringLabelerCustomizer.this.m_attListField.getText() : "";
                m.setAttsToApplyTo(atts);
                String match = SubstringLabelerCustomizer.this.m_matchField.getText() != null ? SubstringLabelerCustomizer.this.m_matchField.getText() : "";
                m.setMatch(match);
                String label = SubstringLabelerCustomizer.this.m_labelField.getText() != null ? SubstringLabelerCustomizer.this.m_labelField.getText() : "";
                m.setLabel(label);
                m.setRegex(SubstringLabelerCustomizer.this.m_regexCheck.isSelected());
                m.setIgnoreCase(SubstringLabelerCustomizer.this.m_ignoreCaseCheck.isSelected());
                SubstringLabelerCustomizer.this.m_listModel.addElement(m);
                if (SubstringLabelerCustomizer.this.m_listModel.size() > 1) {
                    SubstringLabelerCustomizer.this.m_upBut.setEnabled(true);
                    SubstringLabelerCustomizer.this.m_downBut.setEnabled(true);
                }
                SubstringLabelerCustomizer.this.m_list.setSelectedIndex(SubstringLabelerCustomizer.this.m_listModel.size() - 1);
            }
        });
        this.m_deleteBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = SubstringLabelerCustomizer.this.m_list.getSelectedIndex();
                if (selected >= 0) {
                    SubstringLabelerCustomizer.this.m_listModel.removeElementAt(selected);
                    if (SubstringLabelerCustomizer.this.m_listModel.size() <= 1) {
                        SubstringLabelerCustomizer.this.m_upBut.setEnabled(false);
                        SubstringLabelerCustomizer.this.m_downBut.setEnabled(false);
                    }
                }
            }
        });
        this.m_upBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JListHelper.moveUp(SubstringLabelerCustomizer.this.m_list);
            }
        });
        this.m_downBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JListHelper.moveDown(SubstringLabelerCustomizer.this.m_list);
            }
        });
        this.m_regexCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object m = SubstringLabelerCustomizer.this.m_list.getSelectedValue();
                if (m != null) {
                    ((SubstringLabeler.Match)m).setRegex(SubstringLabelerCustomizer.this.m_regexCheck.isSelected());
                    SubstringLabelerCustomizer.this.m_list.repaint();
                }
            }
        });
        this.m_ignoreCaseCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object m = SubstringLabelerCustomizer.this.m_list.getSelectedValue();
                if (m != null) {
                    ((SubstringLabeler.Match)m).setIgnoreCase(SubstringLabelerCustomizer.this.m_ignoreCaseCheck.isSelected());
                    SubstringLabelerCustomizer.this.m_list.repaint();
                }
            }
        });
    }

    private void addButtons() {
        JButton okBut = new JButton("OK");
        JButton cancelBut = new JButton("Cancel");
        JPanel butHolder = new JPanel();
        butHolder.setLayout(new GridLayout(1, 2));
        butHolder.add(okBut);
        butHolder.add(cancelBut);
        this.add((Component)butHolder, "South");
        okBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubstringLabelerCustomizer.this.closingOK();
                SubstringLabelerCustomizer.this.m_parent.dispose();
            }
        });
        cancelBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubstringLabelerCustomizer.this.closingCancel();
                SubstringLabelerCustomizer.this.m_parent.dispose();
            }
        });
    }

    protected void initialize() {
        String[] parts;
        String mString = this.m_labeler.getMatchDetails();
        this.m_listModel = new DefaultListModel();
        this.m_list.setModel(this.m_listModel);
        if (mString != null && mString.length() > 0 && (parts = mString.split("@@match-rule@@")).length > 0) {
            this.m_upBut.setEnabled(true);
            this.m_downBut.setEnabled(true);
            String[] stringArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String mPart = stringArray[n2];
                SubstringLabeler.Match m = new SubstringLabeler.Match(mPart);
                this.m_listModel.addElement(m);
                ++n2;
            }
            this.m_list.repaint();
        }
    }

    @Override
    public void setObject(Object o) {
        if (o instanceof SubstringLabeler) {
            this.m_labeler = (SubstringLabeler)o;
            this.m_tempEditor.setTarget(o);
            this.setup();
            this.initialize();
        }
    }

    @Override
    public void setParentWindow(Window parent) {
        this.m_parent = parent;
    }

    @Override
    public void setModifiedListener(BeanCustomizer.ModifyListener l) {
        this.m_modifyL = l;
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    protected void closingOK() {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < this.m_listModel.size()) {
            SubstringLabeler.Match m = (SubstringLabeler.Match)this.m_listModel.elementAt(i);
            buff.append(m.toStringInternal());
            if (i < this.m_listModel.size() - 1) {
                buff.append("@@match-rule@@");
            }
            ++i;
        }
        this.m_labeler.setMatchDetails(buff.toString());
        this.m_labeler.setNominalBinary(this.m_nominalBinaryCheck.isSelected());
        this.m_labeler.setConsumeNonMatching(this.m_consumeNonMatchingCheck.isSelected());
        this.m_labeler.setMatchAttributeName(this.m_matchAttNameField.getText());
        if (this.m_modifyL != null) {
            this.m_modifyL.setModifiedStatus(this, true);
        }
    }

    protected void closingCancel() {
    }
}

